<?php
class DBManeger
{
    private $Host = DB_HOST;        
    private $Database = DB_NAME;    
    private $User = DB_USER;        
    private $Password = DB_PASS;    
    private $Link_ID = null;        
    private $Query_ID = null;       
    private $Record = array();      
    private $Row;                   
    private $Errno = 0;             
    private $Error = "";
    private $last_insert_id = 0;

    /**
     * Handles database errors by displaying a message and halting execution.
     * @param string $msg
     */
    private function halt($msg)
    {
        echo("<b>Database error:</b> $msg<br>\n");
        echo("<b>MySQL error:</b> $this->Errno ($this->Error)<br>\n");
        die("Session halted.");
    }

    /**
     * Connects to the database if not already connected.
     */
    private function connect()
    {
        if ($this->Link_ID === null) {
            $this->Link_ID = new mysqli($this->Host, $this->User, $this->Password, $this->Database);

            if ($this->Link_ID->connect_error) {
                $this->halt("Connection failed: " . $this->Link_ID->connect_error);
            }
        }
    }

    /**
     * Executes an SQL query.
     * @param string $Query_String
     * @return mysqli_result|bool
     */
    public function query($Query_String)
    {
        $this->connect();
        $this->Query_ID = $this->Link_ID->query($Query_String);

        if (!$this->Query_ID) {
            $this->Errno = $this->Link_ID->errno;
            $this->Error = $this->Link_ID->error;
            $this->halt("Invalid SQL: " . $Query_String);
        }

        $this->last_insert_id = $this->Link_ID->insert_id;

        return $this->Query_ID;
    }

    /**
     * Prepares an SQL statement.
     * @param string $query
     * @return mysqli_stmt|false
     */
    public function prepare($query)
    {
        $this->connect(); // Ensure the database connection is established
        $stmt = $this->Link_ID->prepare($query);
        if (!$stmt) {
            $this->halt("Failed to prepare statement: " . $this->Link_ID->error);
        }
        return $stmt;
    }

    /**
     * Returns the ID of the last inserted record.
     * @return int
     */
    public function getInsertId()
    {
        return $this->last_insert_id;
    }

    /**
     * Returns the database connection object.
     * @return mysqli
     */
    public function getLinkID()
    {
        return $this->Link_ID;
    }

    /**
     * Fetches the next record from a query result as an associative array.
     * @param mysqli_result $Q_id
     * @return array|false
     */
    public function nextRecord($Q_id)
    {
        $this->Record = $Q_id->fetch_array(MYSQLI_ASSOC);
        $this->Row += 1;
        $this->Errno = $this->Link_ID->errno;
        $this->Error = $this->Link_ID->error;

        if (!$this->Record) {
            $Q_id->free();
            $this->Query_ID = null;
        }

        return $this->Record;
    }

    /**
     * Fetches a single record from a query result as an associative array.
     * @param mysqli_result $Q_id
     * @return array|false
     */
    public function getQueryArray($Q_id)
    {
        return $Q_id->fetch_array(MYSQLI_ASSOC);
    }

    /**
     * Returns the number of rows in a query result.
     * @param mysqli_result $Q_id
     * @return int
     */
    public function numRows($Q_id)
    {
        return $Q_id->num_rows;
    }

    /**
     * Closes the database connection.
     */
    public function close()
    {
        if ($this->Link_ID !== null) {
            $this->Link_ID->close();
            $this->Link_ID = null;
        }
    }

    /**
     * Destructor to ensure the database connection is closed.
     */
    public function __destruct()
    {
        $this->close();
    }
}